% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R
\name{fuseVec}
\alias{fuseVec}
\title{Computes the correlation between a composite and a vector of items.}
\usage{
fuseVec(r_mat, a, wt_a = rep(1, length(a)), output = "vec")
}
\arguments{
\item{r_mat}{A correlation matrix.}

\item{a}{The items used for composite A specified as a vector of column numbers.}

\item{wt_a}{A vector containing the weights of each item in composite A.}

\item{output}{Output can be set to "mat", to return a matrix made up of the
newly generated correlations appened to the original correlation matrix.}
}
\value{
A vector of correlation coefficients.
}
\description{
Computes the correlation between a composite and a vector of items.
}
\examples{
data(dls2007)
dat <- dls2007
rxx <- dat[1:4, 2:5]
items <- c(1,3)
wt_a <- c(2,1)

fuseVec(r_mat=rxx, a=items)
fuseVec(r_mat=rxx, a=items, wt_a=wt_a, output="mat")
}
\author{
Allen Goebl and Jeff Jones
}
\references{
Lord, F.M. & Novick, M.R. (1968). \emph{Statisticl theories of 
            mental test scores.}, 97-98.
}

