% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R
\name{fuse}
\alias{fuse}
\title{Computes the correlation between two composites of items.}
\usage{
fuse(r_mat, a, b, wt_a = rep(1, length(a)), wt_b = rep(1, length(b)))
}
\arguments{
\item{r_mat}{A correlation matrix.}

\item{a}{The items used for composite A specified as a vector of column numbers.}

\item{b}{The items used for composite B specified as a vector of column numbers.}

\item{wt_a}{A vector containing the weights of each item in composite A.}

\item{wt_b}{A vector containing the weights of each item in composite B.}
}
\value{
A correlation coefficient.
}
\description{
Computes the correlation between two composites of items. Composites may 
contain overalapping items. Items weights for each composite may be specified.
}
\examples{
Rxx <- matrix(c(1.00, 0.25,  0.50,  0.61,
                0.25, 1.00,  0.30,  0.10,
                0.50, 0.30,  1.00, -0.30,
                0.61, 0.10, -0.30,  1.00), 4, 4)
a   <- c(1, 3)
b   <- c(2, 4)

# Example using overlapping items and weights
Rxx  <- matrix(.3, 4, 4); diag(Rxx) <- 1
a    <- c(1, 2, 4)
b    <- c(2, 3)
wt_a <- c(.60, .25, .15)
wt_b <- c(2, 3)

fuse(r_mat = Rxx, a = a, b = b, wt_a = wt_a, wt_b = wt_b)

}
\author{
Allen Goebl and Jeff Jones
}
\references{
Lord, F.M. & Novick, M.R. (1968). \emph{Statisticl theories of 
            menal test scores.}, 97-98.
}

