% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.scale.xy.R
\name{data.scale.xy}
\alias{data.scale.xy}
\title{Data Transformation for Testing Equality of Variability Measures}
\usage{
data.scale.xy(x, y, scale.option = c("Levene.Med.0", "Levene.Med",
  "Levene.Med.00", "Variance"), scale.adj = TRUE, scale.00 = 2,
  paired = FALSE)
}
\arguments{
\item{x}{A vector specifying the first sample.}

\item{y}{A vector specifying the second sample.}

\item{scale.option}{A character string specifying the transformation on each observation; "Levene.med" for Levene's transformation (absolute difference from the sample median), "Levene.med.0" for Levene's transformation with zero removal for odd sample(s), "Levene.med.00" for Levene's transformation with zero removal for both odd and even sample(s), and "Variance" for squared difference from the sample mean. The default option is "Levene.med.0".}

\item{scale.adj}{A boolean specifying whether or not any constant should be multiplied to each transformed observation. This is useful to obtain unbiased estimates. The default option is TRUE.}

\item{scale.00}{A scale to be applied for an even sample when "Levene.med.00" is chosen. The default option is 2, but the square root of 2 is another viable option.}

\item{paired}{A boolean specifying whether or not the samples are paired or independent. The default option is FALSE.}
}
\value{
\item{trans.x}{Transformed first sample.}
\item{trans.y}{Transformed second sample.}
\item{rho}{Sample correlation coefficient. For independent samples, it returns a NULL.}
}
\description{
Data transformation for testing equality of variability measures (mean absolute deviation from median or variance).
}
\examples{
 set.seed(123)
 x<-runif(10)
 y<-runif(15)
 data.scale.xy(x, y, scale.option="Levene.Med.0", scale.adj=TRUE, paired=FALSE)

}
