% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iface-class.R
\name{imissing}
\alias{imissing}
\title{Test if an \code{iface} parameter was supplied to a function}
\usage{
imissing(param)
}
\arguments{
\item{param}{a parameter name, as supplied to the enclosing function}
}
\value{
TRUE if the parameter was not supplied to the function
}
\description{
As interfacer uses default values to specify the interface, a value will
always be available, but it may be the \code{iface} spec itself. This is picked
up by \code{ivalidate} calls and default value substituted if defined. This means
that if you want to know that the parameter was not supplied you cannot use
\code{rlang::is_missing(...)} as it will always think there is a default.
\code{base::missing(...)} on the other hand will work as it differentiates between
defaults and supplied values. This is a wrapper around \code{base::missing} to
remind us to use it.
}
\examples{
my_iface = iface(
  col1 = integer + group_unique ~ "an integer column",
  .default = tibble::tibble(col1 = 1:3)
)

x = function(df = my_iface, ...) {
  if(imissing(df)) {
    message("missing parameter")
  } else {
    message("parameter given")
  }
  df = ivalidate(df)
  return(df)
}

x() # missing parameter message, and function returns default value
try(x(iris)) # parameter given message but input will not validate
}
