% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{plot.intensitynet}
\alias{plot.intensitynet}
\title{Plot intensitynet object}
\usage{
\method{plot}{intensitynet}(
  x,
  vertex_labels = "none",
  edge_labels = "none",
  xy_axes = TRUE,
  enable_grid = FALSE,
  show_events = FALSE,
  alpha = 1,
  path = NULL,
  ...
)
}
\arguments{
\item{x}{intensitynet object}

\item{vertex_labels}{list -> labels for the vertices}

\item{edge_labels}{list -> labels for the edges}

\item{xy_axes}{show the x and y axes}

\item{enable_grid}{draw a background grid}

\item{show_events}{option to show the events as orange squares, FALSE by default}

\item{alpha}{optional argument to set the transparency of the events (show_events = TRUE). The range is from 0.1 (transparent) to 1 (opaque). Default: alpha = 1}

\item{path}{vector with the nodes of the path to be highlighted. Default NULL}

\item{...}{extra arguments for the plot}
}
\value{
No return value, same as graphics::plot.
}
\description{
Plot intensitynet object
}
\examples{

data("und_intnet_chicago")
plot(und_intnet_chicago) # basic plot
plot(und_intnet_chicago, enable_grid = TRUE) # with grid
plot(und_intnet_chicago, xy_axes = FALSE) # without axes
plot(und_intnet_chicago, path = c("V1","V2","V24","V25","V26","V48")) # highlight a path

}
