% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demultiplex.R
\name{demultiplex}
\alias{demultiplex}
\title{Demultiplex merged FASTQ}
\usage{
demultiplex(
  R1,
  R2 = NULL,
  tags,
  up,
  down,
  destdir = "demux",
  adapter1 = NULL,
  adapter2 = NULL
)
}
\arguments{
\item{R1}{character string giving the path to the first FASTQ file}

\item{R2}{character string giving the path to the second FASTQ file.
Set to NULL for single-end reads.}

\item{tags}{named character vector specifying the unique forward:reverse
tag combinations used in the run.
Each tag combination should be entered as an upper case character string delimited by a colon
(e.g. "ATCGACAC:ATGCACTG") and named according to the unique sample ID.}

\item{up, down}{upper case character strings giving the forward and reverse primer sequences.}

\item{destdir}{character string giving the path to the directory where
the new FASTQ files should be written.}

\item{adapter1}{the forward flowcell adapter sequence to check and trim (set NULL to ignore).
For standard Illumina MiSeq forward adapter set to "AATGATACGGCGACCACCGAGATCTACAC" (paired end sequencing only).}

\item{adapter2}{the reverse flowcell adapter sequence to check and trim (set NULL to ignore).
For standard Illumina MiSeq reverse adapter set to "CAAGCAGAAGACGGCATACGAGAT" (single or paired end sequencing).}
}
\value{
NULL (invisibly)
}
\description{
This function is used to demultiplex FASTQ files
  containing sequence reads with index and primer sequences still attached.
  The function trims the tags and primers, and exports
  two FASTQ files for each forward-reverse index combination.
}
\author{
Shaun Wilkinson
}
