% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_eval_in_data_context}
\alias{bru_eval_in_data_context}
\title{Evaluate expressions in data contexts}
\usage{
bru_eval_in_data_context(
  input,
  data = NULL,
  default = NULL,
  .envir = parent.frame()
)
}
\arguments{
\item{input}{An expression to be evaluated}

\item{data}{list of data objects in priority order. Named elements will
be available as \code{.name.} in the evaluation. The \code{input} expression is
evaluated with each non-NULL \code{data} object as \code{envir}, in order,
until success. If there are no non-NULL data objects, the expression is
evaluated in an empty environment, potentially falling back to enclosing
environment variables.}

\item{default}{Value used if the expression is evaluated as NULL. Default
NULL}

\item{.envir}{The evaluation environment}
}
\value{
The result of expression evaluation
}
\description{
Evaluate an expression in a series of data contexts, also making
the objects directly available as names surrounded by ".", stopping when
the expression evaluation completes with no error.

This is an internal inlabru method, not intended for general use.
}
\examples{
# The A values come from the 'data' element, and the B values come from
# the 'response_data' element, as that is listed first.
bru_eval_in_data_context(
  quote(
    list(A = .data.$x, B = x)
  ),
  list(
    response_data = tibble::tibble(x = 1:5),
    data = tibble::tibble(x = 1:10)
  )
)
# Both A and B come from the 'data' element, as 'x' is found there,
# terminating the evaluation attempt.
bru_eval_in_data_context(
  quote(
    list(A = .data.$x, B = x)
  ),
  list(
    data = tibble::tibble(x = 1:10),
    response_data = tibble::tibble(x = 1:5)
  )
)

}
\keyword{internal}
