% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{bru_comp_list}
\alias{bru_comp_list}
\alias{bru_component_list}
\alias{component_list}
\alias{bru_comp_list.formula}
\alias{bru_comp_list.list}
\alias{c.bru_comp_list}
\alias{c.bru_comp}
\alias{[.bru_comp_list}
\title{Methods for inlabru component lists}
\usage{
bru_comp_list(object, lhoods = NULL, .envir = parent.frame(), ...)

\method{bru_comp_list}{formula}(object, lhoods = NULL, .envir = parent.frame(), ...)

\method{bru_comp_list}{list}(
  object,
  lhoods = NULL,
  .envir = parent.frame(),
  inputs = NULL,
  ...
)

\method{c}{bru_comp_list}(...)

\method{c}{bru_comp}(...)

\method{[}{bru_comp_list}(x, i)
}
\arguments{
\item{object}{The object to operate on}

\item{lhoods}{A \link{bru_obs_list} object}

\item{.envir}{An evaluation environment for non-formula input}

\item{\dots}{Parameters passed on to other methods. Also see Details.}

\item{inputs}{A tree-like list of component input evaluations,
from \code{\link[=bru_input.bru_obs_list]{bru_input.bru_obs_list()}}.}

\item{x}{\code{bru_comp_list} object from which to extract a sub-list}

\item{i}{indices specifying elements to extract}
}
\description{
Constructor methods for inlabru component lists. Syntax details are given in
\code{\link[=bru_comp]{bru_comp()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_comp_list(formula)}: Convert a component formula
into a \code{bru_comp_list} object

\item \code{bru_comp_list(list)}: Combine a list of components and/or component
formulas into a \code{bru_comp_list} object

}}
\section{Methods (by generic)}{
\itemize{
\item \code{c(bru_comp_list)}: The \code{...} arguments should be \code{bru_comp_list}
objects. The environment from the first argument will be applied to the
resulting \code{bru_comp_list}.

}}
\section{Functions}{
\itemize{
\item \code{c(bru_comp)}: The \code{...} arguments should be \code{component}
objects from \code{\link[=bru_comp]{bru_comp()}}. The environment from the first argument
will be applied to the resulting \code{bru_comp_list}.

}}
\examples{
# As an example, let us create a linear component. Here, the component is
# called "myLinearEffectOfX" while the covariate the component acts on is
# called "x". Note that a list of components is returned because the
# formula may define multiple components

eff <- bru_comp_list(~ myLinearEffectOfX(main = x, model = "linear"))
summary(eff[[1]])
# Equivalent shortcuts:
eff <- bru_comp_list(~ myLinearEffectOfX(x, model = "linear"))
eff <- bru_comp_list(~ myLinearEffectOfX(x))
# Individual component
eff <- bru_comp("myLinearEffectOfX", main = x, model = "linear")
}
\seealso{
Other component constructors: 
\code{\link{bru_comp}()}

Other component constructors: 
\code{\link{bru_comp}()}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{component constructors}
