% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_riskmatrix.R
\name{gg_riskmatrix}
\alias{gg_riskmatrix}
\title{Plot risk matrices}
\usage{
gg_riskmatrix(
  injd,
  by = NULL,
  method = c("poisson", "negbin", "zinfpois", "zinfnb"),
  add_contour = TRUE,
  title = NULL,
  xlab = "Incidence (injuries per _)",
  ylab = "Mean time-loss (days) per injury",
  errh_height = 1,
  errv_width = 0.05,
  cont_max_x = NULL,
  cont_max_y = NULL,
  ...
)
}
\arguments{
\item{injd}{\code{injd} \strong{S3} object (see
\code{\link[=prepare_all]{prepare_all()}}).}

\item{by}{Character specifying the name of the column. A (categorical)
variable referring to the "type of case" (e.g. "type of injury"
muscular/articular/others or overuse/not-overuse etc.) according to which
visualize epidemiological summary statistics (optional, defaults to
\code{NULL}).}

\item{method}{Method to estimate the incidence (burden) rate. One of
"poisson", "negbin", "zinfpois" or "zinfnb"; that stand for Poisson method,
negative binomial method, zero-inflated Poisson and zero-inflated negative
binomial.}

\item{add_contour}{Logical, whether or not to add contour lines of the
product between case incidence and mean severity (i.e. 'incidence x
average time-loss'), which leads to case burden (defaults to
\code{TRUE}).}

\item{title}{Text for the main title passed to
\code{\link[ggplot2:ggtitle]{ggplot2::ggtitle()}}.}

\item{xlab}{x-axis label to be passed to
\code{\link[ggplot2:xlab]{ggplot2::xlab()}}.}

\item{ylab}{y-axis label to be passed to
\code{\link[ggplot2:ylab]{ggplot2::ylab()}}.}

\item{errh_height}{Set the height of the horizontal interval whiskers; the
\code{height} argument for
\code{\link[ggplot2:geom_errorbar]{ggplot2::geom_errorbar()}}.}

\item{errv_width}{Set the width of the vertical interval whiskers; the
\code{width} argument for \cr
\code{\link[ggplot2:geom_errorbar]{ggplot2::geom_errorbar()}}.}

\item{cont_max_x, cont_max_y}{Numerical (optional) values indicating the
maximum on the x-axis and y-axis, respectively, to be reached by the
contour.}

\item{...}{Other arguments passed on to
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}} and
\code{\link[metR:geom_text_contour]{metR::geom_text_contour()}}.
These are often aesthetics like \code{bins = 15} or \code{breaks = 10}.}
}
\value{
A ggplot object (to which optionally more layers can be added).
}
\description{
Depict risk matrix plots, a graph in which the case (e.g. injury) incidence (frequency)
is plotted against the average days lost per case (consequence). The point
estimate of case incidence together with its confidence interval is
plotted, according to the method specified. On the y-axis, the mean time-loss
per case together with \eqn{\pm} IQR (days) is plotted. The number shown
inside the point and the point size itself, report the case burden (days
lost per athlete-exposure time), the bigger the size the greater the burden.
See References section.
}
\examples{
\donttest{
df_exposures <- prepare_exp(raw_df_exposures, person_id = "player_name",
                            date = "year", time_expo = "minutes_played")
df_injuries  <- prepare_inj(raw_df_injuries, person_id = "player_name",
                            date_injured = "from", date_recovered = "until")
injd         <- prepare_all(data_exposures = df_exposures,
                            data_injuries  = df_injuries,
                            exp_unit = "matches_minutes")
}

\donttest{
gg_riskmatrix(injd)
gg_riskmatrix(injd, by = "injury_type", title = "Risk matrix")
}
}
\references{
Bahr R, Clarsen B, Derman W, et al. International Olympic Committee
consensus statement: methods for recording and reporting of epidemiological
data on injury and illness in sport 2020 (including STROBE Extension for
Sport Injury and Illness Surveillance (STROBE-SIIS)) \emph{British Journal of
Sports Medicine} 2020; 54:372-389.

Fuller C. W. (2018). Injury Risk (Burden), Risk Matrices and Risk Contours
in Team Sports: A Review of Principles, Practices and Problems.\emph{Sports
Medicine}, 48(7), 1597–1606. \cr \doi{10.1007/s40279-018-0913-5}
}
