% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scv.2d.R
\name{scv.2d}
\alias{scv.2d}
\title{Function performing two-dimensional decomposition of the squared
coefficient of variation (SCV)}
\usage{
scv.2d(
  data,
  total,
  feature = NULL,
  sources = NULL,
  weights = NULL,
  perc = FALSE
)
}
\arguments{
\item{data}{Data frame containing income data. Must contain at least one
column with numeric values.}

\item{total}{String specifying the name of the column containing data on
total income.}

\item{feature}{String specifying the name of the column containing
information about the feature used for inequality decomposition. If left
blank, total income is not decomposed by feature.}

\item{sources}{Vector containing strings specifying the names of the columns
with data on income sources, the sum of which must be equal to total income.
If left blank, or the same value as in "total" is specified, then total
income is not decomposed by income source.}

\item{weights}{String specifying the name of the column containing population
weights.}

\item{perc}{If set to TRUE, then the function returns percentage shares of
every inequality component in overall inequality. Set to FALSE by default.}
}
\value{
Data frame containing values of components of SCV.

Columns of the data frame represent values of the feature used for
decomposition. There can be inequality within groups formed by this feature
and between them - there are twice as much columns as values of the given
feature. Whether a column contains a value of within or between-group
inequality is indicated by ".W" and ".B" suffixes respectively.

Every row of the data frame represents an income source.

Thus, every value in this data frame is the contribution of inequality in
income earned from i-th source by members of j-th population cohort to
overall income inequality.

Remember that overall SCV, which is the sum of all values in the data
frame, is always positive. However, some components of the coefficient can
have negative contribution to inequality.

If all members of the studied population earn the same income, SCV normally
must be equal to zero. But, scv.2d calculates "alpha," which is the absolute
contribution of the given income source to overall inequality. Its
calculation is impossible for identical incomes because the formula involves
division by variance of income, which is zero in this case. Thus, the
function will return the NaN value.
}
\description{
The function performs two-dimensional decomposition of the
squared coefficient of variation according to Garcia-Penalosa & Orgiazzi
(2013). That is, the coefficient can be decomposed by some feature that
members of the studied population possess (e.g., sex, education, age) and
their income source at the same time.
}
\examples{
# Load the test data set.
data("us16")

# No decomposition, just SCV of total income.
result <- scv.2d(us16, "hitotal", weights = "hpopwgt")

# Decomposition of income inequality by gender.
result <- scv.2d(us16, "hitotal", "sex", "hitotal", "hpopwgt")

# Decomposition of income inequality by gender and income source.
result <- scv.2d(us16, "hitotal", "sex", c("hilabour", "hicapital",
"hitransfer"), "hpopwgt")
}
\references{
Garcia-Penalosa, C., & Orgiazzi, E. (2013). Factor Components of Inequality:
A Cross-Country Study. Review of Income and Wealth, 59(4), 689-727.
}
