% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_series_eng.R
\name{inegi_series}
\alias{inegi_series}
\title{Returns INEGI data series}
\usage{
inegi_series(series_id, token, geography = "00", database = "BIE",
  metadata = FALSE, lastonly = FALSE, as_tt = FALSE,
  as_compact = FALSE)
}
\arguments{
\item{series_id}{an indicator ID. These are obtained via the INEGI API documentation.}

\item{token}{API token supplied by INEGI.}

\item{geography}{Geography code of INEGI. Defaults to 00 (National)}

\item{database}{Is the id from BIE (Banco de Informacion Economica) or BISE (Banco de Indicadores)? Defaults to BIE. To learn more about what database your indicator is stored in, visit INEGI docs.}

\item{metadata}{Defaults to FALSE, if TRUE, returns a list with metadata information.}

\item{lastonly}{Do you want only the last observation? Defaults to FALSE.}

\item{as_tt}{Do you want the output of the data.frame to be a tibble time object? Defaults to FALSE.}

\item{as_compact}{Do you want the output always as a data.frame or time tibble? If the output contains metadata, each data point will be replicated in a column. If the output does not contain metadata there is no change. Previously, this was achieved with \code{compact_inegi_series}.}
}
\value{
data.frame or list
}
\description{
Returns a data.frame with the time series chosen from INEGI webservice. If the parameter Metadata is TRUE, a list is returned with two objects: data and metadata.
}
\note{
Adding the entire INEGI URL as a series is deprecated since v3, due to a change of API specifications in INEGI. INEGI docs can be found at: \url{https://www.inegi.org.mx/servicios/api_indicadores.html}. Coercing biweekly indicators to monthly is also deprecated inside this function. Use tibbletime functions to coerce instead.
}
\examples{
\dontrun{
# General INPC series
token <- "webservice_token"
inpc_id <- "216064"
INPC <- inegi_series(inpc_id, token)
}
}
\author{
Eduardo Flores
}
