% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_aux.R
\name{incat_}
\alias{incat_}
\alias{incat_freq}
\alias{incat_source}
\alias{incat_notes}
\alias{incat_topic}
\alias{incat_indicator}
\title{Get INEGI Catalogs}
\usage{
incat_freq(token, id = NULL)

incat_source(token, id = NULL)

incat_notes(token, id = NULL)

incat_topic(token, id = NULL)

incat_indicator(token, id = NULL)
}
\arguments{
\item{token}{INEGI API token}

\item{id}{Optional id. If NULL, will download entire catalog.}
}
\value{
data.frame
}
\description{
Allows you to download the catalogs of frequencies, sources, notes, topics and indicator names. Called in the background in some functions.
}
\examples{

# Get the corresponding frequency for frequency id #8 (monthly)
\dontrun{
token <- "webservice token"
incat_freq(token, id = "8")
}
# Get all of the note descriptions
\dontrun{
token <- "webservice token"
incat_notes(token)
}
#' # Get all of the sources descriptions
\dontrun{
token <- "webservice token"
incat_source(token)
}
}
\author{
Eduardo Flores
}
