% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_test.R
\name{test_diff}
\alias{test_diff}
\title{Test the difference for delay model parameter(s) between two uncorrelated groups, based on maximum product of spacings estimation (MPSE).}
\usage{
test_diff(
  x,
  y = stop("Provide data for group y!"),
  distribution = c("exponential", "weibull"),
  twoPhase = FALSE,
  method = c("MPSE", "MLEn", "MLEw", "MLEc"),
  profiled = method == "MLEw",
  ties = c("density", "equidist", "random", "error"),
  param = "delay1",
  type = c("all", "bootstrap", "GOF", "moran", "pearson", "logrank", "LR"),
  doLogrank = TRUE,
  R = 400,
  chiSqApprox = FALSE,
  verbose = 0
)
}
\arguments{
\item{x}{data from reference/control group.}

\item{y}{data from the treatment group.}

\item{distribution}{character(1). Name of the parametric delay distribution to use.}

\item{twoPhase}{logical(1). Do we model two phases per group? Default is \code{FALSE}, i.e. a single delay phase per group.}

\item{method}{character. Which method to fit the models.}

\item{profiled}{logical. Use the profiled likelihood?}

\item{ties}{character. How to handle ties in data vector of a group?}

\item{param}{character. Names of parameters to test difference for. Default value is \code{'delay1'}.}

\item{type}{character. Which type of tests to perform?}

\item{doLogrank}{logical. In any case do log-rank based tests?}

\item{R}{numeric(1). Number of bootstrap samples to evaluate the distribution of the test statistic.}

\item{chiSqApprox}{logical flag. In bootstrap, should we calculate the approximate degrees of freedom for the distribution of the test statistic under H0?}

\item{verbose}{numeric. How many details are requested? Higher value means more details. 0=off, no details.}
}
\value{
list with the results of the test. Element P contains the different P-values, for instance from parametric bootstrap
}
\description{
It is in fact a model comparison between a null model where the parameters are enforced to be equal and an unconstrained full model.
As test statistic we use twice the difference in best (=lowest) objective function value, i.e. 2 * (\code{val_0} - \code{val_1}).
This is reminiscent of a likelihood ratio test statistic albeit the objective function is not a negative log-likelihood
but the negative of the maximum product spacing metric.
}
\details{
High values of this difference speak against the null-model (i.e. high \code{val_0} indicates bad fit under 0-model and low values of \code{val_1} indicate a good fit under the more general model1.
The test is implemented as a parametric bootstrap test, i.e. we
\enumerate{
\item take given null-model fit as ground truth
\item regenerate data according to this model.
\item recalculate the test statistic
\item appraise the observed test statistic in light of the generated distribution under H0
}
}
