% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{delay_fit}
\alias{delay_fit}
\title{Fit optimal parameters according to the objective function (either MPSE or MLE-based).}
\usage{
delay_fit(objFun, optim_args = NULL, verbose = 0)
}
\arguments{
\item{objFun}{objective function to be minimized}

\item{optim_args}{list of own arguments for optimization. If \code{NULL} it uses the default optim arguments associated to the objective function.}

\item{verbose}{integer that indicates the level of verboseness. Default 0 is quiet.}
}
\value{
optimization object including a named parameter vector or \code{NULL} in case of errors during optimization
}
\description{
The objective function carries the given data in its environment and it is to be minimized.
R's standard routine \code{stats::optim} does the numerical optimization, using numerical derivatives.
or the analytical solution is returned directly if available.
}
