% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay.R
\name{DelayedWeibull}
\alias{DelayedWeibull}
\alias{dweib_delayed}
\alias{pweib_delayed}
\alias{qweib_delayed}
\alias{rweib_delayed}
\alias{mweib_delayed}
\title{Delayed Weibull Distribution}
\usage{
dweib_delayed(
  x,
  delay1,
  shape1,
  scale1 = 1,
  delay2 = NULL,
  shape2 = NULL,
  scale2 = 1,
  delay = delay1,
  shape = shape1,
  scale = scale1,
  log = FALSE
)

pweib_delayed(
  q,
  delay1,
  shape1,
  scale1 = 1,
  delay2 = NULL,
  shape2 = NULL,
  scale2 = 1,
  delay = delay1,
  shape = shape1,
  scale = scale1,
  lower.tail = TRUE,
  log.p = FALSE
)

qweib_delayed(
  p,
  delay1,
  shape1,
  scale1 = 1,
  delay2 = NULL,
  shape2 = NULL,
  scale2 = 1,
  delay = delay1,
  shape = shape1,
  scale = scale1,
  lower.tail = TRUE,
  log.p = FALSE
)

rweib_delayed(
  n,
  delay1,
  shape1,
  scale1 = 1,
  delay2 = NULL,
  shape2 = NULL,
  scale2 = 1,
  delay = delay1,
  shape = shape1,
  scale = scale1
)

mweib_delayed(
  t = +Inf,
  delay1,
  shape1,
  scale1 = 1,
  delay2 = NULL,
  shape2 = NULL,
  scale2 = 1,
  delay = delay1,
  shape = shape1,
  scale = scale1
)
}
\arguments{
\item{x}{A numeric vector of values for which to get the density.}

\item{delay1}{numeric. The first delay, must be non-negative.}

\item{shape1}{numeric. First shape parameter, must be positive.}

\item{scale1}{numeric. First scale parameter (inverse of rate), must be positive.}

\item{delay2}{numeric. The second delay, must be non-negative.}

\item{shape2}{numeric. The second shape parameter, must be non-negative.}

\item{scale2}{numeric. The second scale parameter (inverse of rate), must be positive.}

\item{delay}{numeric. Alias for first delay.}

\item{shape}{numeric. Alias for first shape.}

\item{scale}{numeric. Alias for first scale.}

\item{log}{logical. Return value on log-scale?}

\item{q}{A numeric vector of quantile values.}

\item{lower.tail}{logical. Give cumulative probability of lower tail?}

\item{log.p}{logical. P-value on log-sclae?}

\item{p}{A numeric vector of probabilities.}

\item{n}{integer. Number of random observations requested.}

\item{t}{A numeric vector of times that restrict the mean survival. Default is \code{+Inf}, i.e., the unrestricted mean survival time.}
}
\value{
Functions pertaining to the delayed Weibull distribution:
\itemize{
\item \code{dweib_delayed} gives the density
\item \code{pweib_delayed} gives the distribution function
\item \code{qweib_delayed} gives the quantile function
\item \code{rweib_delayed} generates a pseudo-random sample
\item \code{mweib_delayed} gives the restricted mean survival time
}

The length of the result is determined by \code{n} for \code{rweib_delayed}, and is the maximum of the lengths of the numerical arguments for the other functions, R's recycling rules apply.
}
\description{
Density, distribution function, quantile function and random generation for the delayed Weibull distribution.
Besides the additional parameter \code{delay}, the other two Weibull-parameters are in principle retained as in R's stats-package:
\itemize{
\item \code{shape}
\item \code{scale} (as inverse of rate)
}
}
\details{
Additional arguments are forwarded via \code{...} to the underlying functions of the exponential distribution in the stats-package.

The numerical arguments other than \code{n} are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\keyword{distribution}
