% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline_model.R
\name{sample_laplace_log_incidence_poisson}
\alias{sample_laplace_log_incidence_poisson}
\title{Generate Laplace samples of incidence}
\usage{
sample_laplace_log_incidence_poisson(
  beta_hat,
  beta_cov,
  reported,
  Q,
  num_samps_per_ar = 10
)
}
\arguments{
\item{beta_hat}{Maximum likelihood solution for beta parameter.}

\item{beta_cov}{Covariance of objective solution (either Fisher information or Hessian inverse).}

\item{reported}{An integer vector of reported cases.}

\item{Q}{Spline basis matrix.}

\item{num_samps_per_ar}{Number of Laplace samples to return for each AR path.}
}
\value{
A matrix of `num_samps_per_ar` log incidence curve samples from laplace approximation of distribution.
}
\description{
This function generates Laplace samples of posterior distribution for a vector of reported incidence.
}
