#ifndef RELASSO_HPP
#define RELASSO_HPP

#include <RcppArmadillo.h>

namespace relasso {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = abs(wt / adjwt - 1.0);
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        colvec df = wt / adjwt;
        colvec dg = df / adjwt;
        return dg % sign(1.0 - df);
    }

}

#endif // RELASSO_HPP
