% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model_Wrappers.r
\name{modelChondrite_lattice}
\alias{modelChondrite_lattice}
\title{Model REE contents using the Chondrite-Lattice method of \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)}}
\usage{
modelChondrite_lattice(
  dat,
  exclude = c("La", "Pr", "Ce", "Eu", "Y"),
  Calibrate = T,
  prefix = NULL,
  suffix = NULL,
  r0 = 0.87,
  chondrite = PalmeOneill2014CI,
  Pr_correction_fact = 1/0.918,
  Y_correction_fact = 1/0.72,
  Dy_correction_fact = 1/1.032,
  Ho_correction_fact = 1,
  Er_correction_fact = 1/0.974,
  Tm_correction_fact = 1,
  Yb_correction_fact = 1/0.8785,
  Lu_correction_fact = 1/0.8943,
  Nd_correction_fact = 1/0.989,
  Sm_correction_fact = 1/1.022,
  Gd_correction_fact = 1/1.033,
  Tb_correction_fact = 1/1.05
)
}
\arguments{
\item{dat}{A data frame with REE data in ppm}

\item{exclude}{a string: vector including elements that should be omitted from modelling. La, Ce and Eu are the default. Ce and Eu should be always included}

\item{Calibrate}{Logical (T or F). If True, the model is calibrated using the correction factors. By default it is the reciprocal of the median REE from the work of Carrasco-Godoy and Campbell is used.}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}

\item{r0}{A number: ionic radii of the lattice site r0. By default is 0.87 A, the median value obtained by Carrasco-Godoy and Campbell.}

\item{chondrite}{an option from: PalmeOneill2014CI, Oneill2014Mantle, McDonough1995CI}

\item{Pr_correction_fact}{a number: correction factor for overestimated Pr 1/0.918}

\item{Y_correction_fact}{a number: correction factor for underestimated Y. 1/ 0.72 by default.}

\item{Dy_correction_fact}{a number: correction factor for overestimated Dy 1/1.032}

\item{Ho_correction_fact}{a number: correction factor for Ho. 1 by default.}

\item{Er_correction_fact}{a number: correction factor for underestimated Er. 1/0.97 by default.}

\item{Tm_correction_fact}{a number: correction factor for Tm. 1 by default.}

\item{Yb_correction_fact}{a number: correction factor for underestimated Yb. 1/0.8785  by default.}

\item{Lu_correction_fact}{a number: correction factor for underestimated Lu. 1/0.8943 by default.}

\item{Nd_correction_fact}{a number: correction factor for underestimated Nd 1/0.0.989}

\item{Sm_correction_fact}{a number: correction factor for overestimated Sm 1/1.022}

\item{Gd_correction_fact}{a number: correction factor for overestimated Gd 1/1.033}

\item{Tb_correction_fact}{a number: correction factor for overestimated Tb 1/1.050}
}
\value{
a dataframe
}
\description{
This function apply the Chondrite-Lattice method which is a linear regression between the misfit parameter from the lattice strain equation and the logarithm of their chondrite normalized values. At least 2 points are required to use this method.
This method is based on the work of  \href{https://www.nature.com/articles/372452a0}{Blundy and Wood (1994)} but using chondrite normalized values as noted by \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)}. Refer to \href{https://link.springer.com/article/10.1007/s00410-023-02025-9}{Carrasco-Godoy and Campbell (2023)} for details.
}
\examples{
Ballard_et_al_Zircon \%>\%  modelChondrite_lattice(prefix = 'Zr', suffix = 'ppm')
}
\seealso{
Other model REE: 
\code{\link{modelChondrite_Onuma}()},
\code{\link{modelZhong}()},
\code{\link{model_REE}()}
}
\concept{model REE}
