#' @name intensity_PXD000022
#' @docType data
#' @title Dataset PXD000022 from ProteomeXchange.
#' @keywords data datasets
#' @format A data frame with 660 observations on the following 7 variables.
#' \describe{
#'        \item{\code{Protein.IDs}}{Peptides/Proteins names}
#'        \item{\code{Intensity.MB.1}}{a numeric vector}
#'        \item{\code{Intensity.MB.2}}{a numeric vector}
#'        \item{\code{Intensity.MB.3}}{a numeric vector}
#'        \item{\code{Intensity.MT.1}}{a numeric vector}
#'        \item{\code{Intensity.MT.2}}{a numeric vector}
#'        \item{\code{Intensity.MT.3}}{a numeric vector}
#'        }
#' @description  This dataset has been collected during a study designed 
#' to compare the protein content of the exosome-like vesicles (ELVs) released 
#' from C2C12 murine myoblasts during proliferation (ELV-MB), and after 
#' differentiation into myotuves (ELV-MT). The dataset within this package 
#' contains proteins intensity processed using MaxQuant. More information 
#' can be found on ProteomeExchange public repository 
#' (http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000022) 
#' or in the original paper (see reference).
#' @usage data(intensity_PXD000022)
#' @source  Original MaxQuant data: 
#' http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000022
#' @references Forterre A, Jalabert A, Berger E, Baudet M, Chikh K, et al. (2014) 
#' Proteomic Analysis of C2C12 Myoblast and Myotube Exosome-Like Vesicles: 
#' A New Paradigm for Myoblast-Myotube Cross Talk? PLoS ONE 9(1): 
#' e84153. doi:10.1371/journal.pone.0084153 
NULL


#' @name intensity_PXD000052
#' @docType data
#' @title Dataset PXD000052 from ProteomeXchange.
#' @keywords data datasets
#' @format A data frame with 1991 observations on the following 17 variables.
#' \describe{
#'        \item{\code{Protein.IDs}}{Peptides/Proteins names}
#'        \item{\code{iBAQ.stSLP_activ1}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_activ2}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_activ3}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_activ4}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_rest1}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_rest2}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_rest3}}{a numeric vector}
#'        \item{\code{iBAQ.stSLP_rest4}}{a numeric vector}
#'        \item{\code{iBAQ.WT_activ1}}{a numeric vector}
#'        \item{\code{iBAQ.WT_activ2}}{a numeric vector}
#'        \item{\code{iBAQ.WT_activ3}}{a numeric vector}
#'        \item{\code{iBAQ.WT_activ4}}{a numeric vector}
#'        \item{\code{iBAQ.WT_rest1}}{a numeric vector}
#'        \item{\code{iBAQ.WT_rest2}}{a numeric vector}
#'        \item{\code{iBAQ.WT_rest3}}{a numeric vector}
#'        \item{\code{iBAQ.WT_rest4}}{a numeric vector}
#'        }
#' @description This dataset has been collected during a study designed to perform 
#' the proteomic analysis of the SLP76 interactome in resting and activated primary 
#' mast cells. Four SLP76 replicates (with two analytical replicates each) have been 
#' affinity-purified from both resting and activated primary mast cells. The dataset 
#' within this package contains proteins intensity processed using MaxQuant. 
#' More information can be found on ProteomeExchange public repository 
#' (http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000052) or 
#' in the original paper (see reference).
#' @usage data(intensity_PXD000052)
#' @source  Original MaxQuant data: 
#' http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000052
#' @references  Bounab Y, Hesse AM, Iannascoli B, Grieco L, Coute Y, Niarakis A, 
#' Roncagalli R, Lie E, Lam KP, Demangel C, Thieffry D, Garin J, Malissen B, 
#' Da?ron M, Proteomic analysis of the SH2 domain-containing leukocyte protein 
#' of 76 kDa (SLP76) interactome in resting and activated primary mast cells [corrected]. 
#' Mol Cell Proteomics, 12(10):2874-89(2013).
NULL




#' @name intensity_PXD000438
#' @docType data
#' @title Dataset PXD000438 from ProteomeXchange. 
#' @description This dataset has been collected during a study designed to compare 
#' human primary tumor-derived xenograph proteomes of the two major histological 
#' non-small cel lung cancer subtypes: adenocarcinoma (ADC) and squamous cell carcinoma (SCC). 
#' The dataset within this package contains proteins intensity for 6 ADC and 6 SCC samples, 
#' processed using MaxQuant. More information can be found on ProteomeExchange public 
#' repository(http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000438) or 
#' in the original paper (see reference). 
#' @usage data(intensity_PXD000438)
#' @format
#'   A data frame with 3709 observations on the following 13 variables.
#'   \describe{
#'     \item{\code{Protein.IDs}}{Peptides/Proteins names}
#'     \item{\code{Intensity.092.1}}{a numeric vector}
#'     \item{\code{Intensity.092.2}}{a numeric vector}
#'     \item{\code{Intensity.092.3}}{a numeric vector}
#'     \item{\code{Intensity.441.1}}{a numeric vector}
#'     \item{\code{Intensity.441.2}}{a numeric vector}
#'     \item{\code{Intensity.441.3}}{a numeric vector}
#'     \item{\code{Intensity.561.1}}{a numeric vector}
#'     \item{\code{Intensity.561.2}}{a numeric vector}
#'     \item{\code{Intensity.561.3}}{a numeric vector}
#'     \item{\code{Intensity.691.1}}{a numeric vector}
#'     \item{\code{Intensity.691.2}}{a numeric vector}
#'     \item{\code{Intensity.691.3}}{a numeric vector}
#'   }
#' 
#' @source Original MaxQuant data: 
#' http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000438 
#' @references Zhang W, Wei Y, Ignatchenko V, Li L, Sakashita S, Pham NA, Taylor P, 
#' Tsao MS, Kislinger T, Moran MF, Proteomic profiles of human lung adeno and squamous 
#' cell carcinoma using super-SILAC and label-free quantification approaches. 
#' Proteomics, 14(6):795-803(2014). 
#' @examples
#'   data(intensity_PXD000438)
NULL


#' @name intensity_PXD000501
#' @docType data
#' @title Dataset PXD000501 from ProteomeXchange. 
#' @description This dataset contains three biological replicates with three 
#' technical replicates each for the conditiones media (CM) and the whole cell 
#' lysates (WCL) of C8-D1A cell lines. The dataset within this package contains 
#' proteins iBAQ intensity processed using MaxQuant. More information can be found 
#' on ProteomeExchange public repository 
#' (http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000501) or 
#' in the original paper (see reference). 
#' @usage data(intensity_PXD000501)
#' @format
#'   A data frame with 7363 observations on the following 19 variables.
#'   \describe{
#'     \item{\code{Protein.IDs}}{Peptides/Proteins names}
#'     \item{\code{iBAQ.secretome_set1_tech1}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set1_tech2}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set1_tech3}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set2_tech1}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set2_tech2}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set2_tech3}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set3_tech1}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set3_tech2}}{a numeric vector}
#'     \item{\code{iBAQ.secretome_set3_tech3}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set1_tech1}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set1_tech2}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set1_tech3}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set2_tech1}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set2_tech2}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set2_tech3}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set3_tech1}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set3_tech2}}{a numeric vector}
#'     \item{\code{iBAQ.whole_set3_tech3}}{a numeric vector}
#'   }
#' @source Original MaxQuant data: 
#' http://proteomecentral.proteomexchange.org/cgi/GetDataset?ID=PXD000501 
#' @references Han D, Jin J, Woo J, Min H, Kim Y, Proteomic analysis of 
#' mouse astrocytes and their secretome by a combination of FASP and StageTip-based, 
#' high pH, reversed-phase fractionation. Proteomics, ():(2014).
#' @examples
#'   data(intensity_PXD000501)
NULL
