% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impreciseImputation.R
\name{impimp}
\alias{impimp}
\alias{print.impimp}
\alias{is.impimp}
\title{Imprecise Imputation for Statistical Matching}
\usage{
impimp(recipient, donor, method = c("variable_wise", "case_wise",
  "domain"), matchvars = NULL, vardomains = NULL)

\method{print}{impimp}(x, ...)

is.impimp(z)
}
\arguments{
\item{recipient}{a data.frame acting as recipient; see details.}

\item{donor}{a data.frame acting as donor; see details.}

\item{method}{1-character string of the desired imputation method.
The following values are possible, see details for an explanantion:
\code{"variable_wise"} (default), \code{"case_wise"} and
\code{"domain"}.}

\item{matchvars}{a character vector containing the variable names
to be used as matching variables. If \code{NULL} (default) all
variables, present in both \code{donor} and \code{recipient} are
used as matching variables.}

\item{vardomains}{a named list containing the possible values of
all variable in \code{donor} that are not present in
\code{recipient}.\cr
If set to \code{NULL} (default) the list is generated by first
coercing all those variables to type \code{\link[base]{factor}}
and then storing their levels.}

\item{x}{object of class 'impimp'}

\item{...}{further arguments passed down to
\code{\link[base]{print.data.frame}}}

\item{z}{object to test for class \code{"impimp"}}
}
\value{
The data.frame resulting in an imprecise imputation
of \code{donor} into \code{recipient}.
It is also of class \code{"impimp"} and stores the imputation
method in its attribute \code{"impmethod"}, the names of the
variables of the resulting object containing imputed values
in the attribute \code{"imputedvarnames"}, as well as the
list of (guessed) levels of each underlying variable in
\code{"varlevels"}.
}
\description{
Impute a data frame imprecisely
}
\details{
As in the context of statistical matching the data.frames
\code{recipient} and \code{donor} are assumed to contain an
overlapping set of variables.

The missing values in \code{recipient} are subsituted with
observed values in \code{donor} for approaches based on donation
classes and otherwise with the set of all possible values for
the variable in question.

For \code{method = "domain"} a missing value of a variable in
\code{recipient} is imputed by the set of all possible values
of that variable.

The other methods are based on donation classes which are formed
based on the matching variables whose names are provided by
\code{matchvars}. They need to be present in both \code{recipient}
and \code{donor}:
For \code{method = "variable_wise"} a missing value of a variable
in \code{recipient} is imputed by the set of all observed values
of that variable in \code{donor}.
For \code{method = "case_wise"} the variables only present in
\code{donor} are represented as tuples. A missing tuple in
\code{recipient} is then imputed by the set of all observed
tuples in \code{donor}.
}
\note{
This method does not require that all variables in \code{recipient}
and \code{donor} are \code{\link[base]{factor}} variables, however,
the imputation methods apply coercion to factor, so purely
numerical variables will be treated as factors eventually.
It does assume (and test for it) that there are no missing
values present in the matching variables.
}
\section{Reserved characters}{

The variable names and observations in \code{recipient} and
\code{donor} must not contain characters that are reserved for
internal purpose.
The actual characters that are internally used are stored in the
options \code{options("impimp.obssep")} and
\code{options("impimp.varssep")}. The former is used to separate
the values of a set-valued observation, while the other is used
for a concise tupel representation.
}

\examples{
A <- data.frame(x1 = c(1,0), x2 = c(0,0),
                y1 = c(1,0), y2 = c(2,2))
B <- data.frame(x1 = c(1,1,0), x2 = c(0,0,0),
                z1 = c(0,1,1), z2 = c(0,1,2))
impimp(A, B, method = "variable_wise")

## Specifically setting the possible levels of 'z1'
impimp(A, B, method = "domain", vardomains = list(z1 = c(0:5)))

}
\references{
Endres, E., Fink, P. and Augustin, T. (2018),
Imprecise Imputation: A Nonparametric Micro Approach Reflecting
the Natural Uncertainty of Statistical Matching with Categorical
Data, \emph{Department of Statistics (LMU Munich): Technical Reports},
No. 214. URL \url{https://epub.ub.uni-muenchen.de/42423/}.
}
\seealso{
for the estimation of probabilities \code{\link{impest}}
and \code{\link{impestcond}}; \code{\link{rbindimpimp}} for
joining two \code{impimp} objects
}
\keyword{datagen}
\keyword{robust}
