% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulatePolicies.R
\name{policies_simulate}
\alias{policies_simulate}
\title{Simulate a data frame of policies}
\usage{
policies_simulate(
  n,
  policy_years,
  num_years,
  exposure = 1,
  retention = 1,
  growth = 0,
  start_id = 1,
  additional_columns
)
}
\arguments{
\item{n}{An integer giving the number of policies in the first year}

\item{policy_years}{A vector of integers in sequence}

\item{num_years}{The number of years to simulate. If `policy_years` is given, this is ignored.}

\item{exposure}{Exposure per policy}

\item{retention}{A vector indicating loss of policies}

\item{growth}{A vector indicating the rate of growth of policies}

\item{start_id}{Integer of the first number in the policy ID sequence}

\item{additional_columns}{A list of addtional column names and values}
}
\value{
A data frame of policy data
}
\description{
Given a starting number of policies, this function will generate additional years of policy data.

Growth is given as a the positive rate of growth of new policies. This may be set to zero.

Retention is given as the portion of expiring policies which will renew.
}
