% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcurve.R
\name{simcurve}
\alias{simcurve}
\title{simcurve}
\usage{
simcurve(numareas = c(300, 300, 300), p = 0.05, type, normerr = 0.1)
}
\arguments{
\item{numareas}{number of areas to generate}

\item{p}{proportion of the areas that have significant change}

\item{type}{type of curves generated}

\item{normerr}{standard deviation of the Normal distribution (with mean zero) of which the coefficients are generated}
}
\value{
Output from the function is a list of two items:
\itemize{
 \item data - simulated data
 \item parameters - parameters used to generate the data}
}
\description{
This function generates two kinds of datasets.
1. Randomly generates curves with change/no change.
2. Generates true curves assumed from fixed coeffecients with some random noise.
}
\details{
If type = "random", the function generates curves with change/no change.
If type = "fixed", the function generates true curves assumed from fixed coefficients with some random noise.
If numareas is not specified, it is assumed as a vector of c(300,300,300).
If normerr is not specified, it is assumed as a value of 0.01. It is ignored when type= "random".
}
\examples{
mydata_ran <- simcurve(numareas = c(300, 300, 300), p=0.01, type="random")

mydata_fixed <- simcurve(numareas = c(300, 300, 300), p=0.01, type="fixed", normerr = 0.1)
}
