% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igrf.R
\name{igrf}
\alias{igrf}
\title{International Geomagnetic Reference Field}
\usage{
igrf(field = "main", year, type = "spheroid", altitude, latitude, longitude)
}
\arguments{
\item{field}{main field (default = "main") or secular variation
("variation") data output}

\item{year}{Decimal year between 1900 and 2030 A.D}

\item{type}{"spheroid" (default) or "sphere" representation}

\item{altitude}{in km above the earth surface for a spheroid type,
or distance from the earth center (radial distance) for the sphere
representation (in the later the value should exceed 3485km)}

\item{latitude}{latitude in decimal degrees}

\item{longitude}{longitude in decimal degrees}
}
\value{
a data frame with components X,Y,Z,F, D, H and I for the main
geomagnetic field or the secular variations, i.e. instantaneous time
rate of change of the geomagnetic main field. Keep in mind that the
secular variations are generally only used for interpolation purposes
and do not reflect the actual rate of change. For more guidance on the
use of the secular variations and caveats we refer to the main project's
website <https://www.ngdc.noaa.gov/IAGA/vmod/igrfhw.html>.
}
\description{
The 13th Generation International Geomagnetic Reference Field.
}
\details{
The R model underpinning the base function is the original Fortran
model published by Alken et al. 2021 and available on the project
website <https://www.ngdc.noaa.gov/IAGA/vmod/igrf.html>.

Outputs have been verified to correspond with the original code with
the exception that values in the R implementation are not rounded before
output (as in the original model). For all intents and purposes the data
can be considered equivalent.

For full model details I refer Alken et al. 2021, and the project website
where both the original code and a brief model description can be found.
The authors of both the R package and the original Fortran code
take no responsibility regarding the use of these data within
a professional context <https://www.ngdc.noaa.gov/IAGA/vmod/igrfhw.html>.
}
\examples{
field <- igrf::igrf(
 field = "main",
 year = 2000,
 type = "spheroid",
 altitude = 2,
 latitude = 50,
 longitude = 10
)
}
