% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_empty_graph}
\alias{make_empty_graph}
\alias{empty_graph}
\title{A graph with no edges}
\usage{
make_empty_graph(n = 0, directed = TRUE)

empty_graph(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{directed}{Whether to create a directed graph.}

\item{...}{Passed to \code{make_graph_empty}.}
}
\value{
An igraph graph.
}
\description{
A graph with no edges
}
\examples{
make_empty_graph(n = 10)
make_empty_graph(n = 5, directed = FALSE)
}
\seealso{
Other deterministic constructors: 
\code{\link{graph_from_atlas}()},
\code{\link{graph_from_edgelist}()},
\code{\link{graph_from_literal}()},
\code{\link{make_}()},
\code{\link{make_chordal_ring}()},
\code{\link{make_full_citation_graph}()},
\code{\link{make_full_graph}()},
\code{\link{make_graph}()},
\code{\link{make_lattice}()},
\code{\link{make_ring}()},
\code{\link{make_star}()},
\code{\link{make_tree}()}
}
\concept{Empty graph.}
\concept{deterministic constructors}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Basic.html#igraph_empty}{\code{empty()}}.}

