# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name enzyme-model
#' @param theta a vector of length 3 containing the model parameters
#' @param n the process is sampled on n equispaced points on the unit interval
#' (default 50)
#' @param E0,S0 initial state of the process
#' (default E0=100, S0=100)
#' @returns
#' `enzymeSim` returns a `n x 4' integer matrix; the ith row contains the  
#' simulated values for E, S, C and P at time t=(i-1)/(n-1).
#' @export
enzymeSim <- function(theta, n = 50L, E0 = 100L, S0 = 100L) {
    .Call(`_ifit_enzymeSim`, theta, n, E0, S0)
}

knnsearch0 <- function(x, k) {
    .Call(`_ifit_knnsearch0`, x, k)
}

knnreg <- function(x, y, xnew, k = 0L) {
    .Call(`_ifit_knnreg`, x, y, xnew, k)
}

#' @rdname toad-model
#' @name toad-model
#' @param theta a vector of length 3 containing the model parameters
#' @param data a (number of days)x(number of toads) numerical matrix 
#'        containing the locations of a set of toads. The simulated
#'        dataset will replicates the size, the NA pattern and
#'        the initial positions (first row) of this argument. 
#' @return
#' `toadSim` return a numerical matrix of the same size of `data`
#' @export
toadSim <- function(theta, data) {
    .Call(`_ifit_toadSim`, theta, data)
}

#' @name trait-model
#' @param theta a vector of length 4 containing the model parameters,
#' @param nspecies the number of different levels of the trait
#'        characteristic (default 1000)
#' @param population number of individuals living in the community
#' (default 500)
#' @param ngen number of generations (death/birth cycles) after which the
#'             actual population is returned (default 5000)
#' @returns
#' `traitSim` returns a integer vector of length `nspecies` containing the trait distribution 
#' of `population` individuals after `ngen` generations 
#' @export
traitSim <- function(theta, nspecies = 1000L, population = 500L, ngen = 5000L) {
    .Call(`_ifit_traitSim`, theta, nspecies, population, ngen)
}

