% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ps_ord}
\alias{ps_ord}
\title{PS-Test for the indirect effect - Ordered Mediators}
\usage{
ps_ord(
  u1 = NULL,
  u2 = NULL,
  u3 = NULL,
  V1Dist = NULL,
  V1 = NULL,
  V1_VAR = NULL,
  V1_DF = NULL,
  V2Dist = NULL,
  V2 = NULL,
  V2_VAR = NULL,
  V2_DF = NULL,
  V2b = 0,
  V2b_VAR = 0,
  V2bmult = 1L,
  V3Dist = NULL,
  V3 = NULL,
  V3_VAR = NULL,
  V3_DF = NULL,
  V3b = 0,
  V3b_VAR = 0,
  V1_V2_cov = 0,
  V1_V2b_cov = 0,
  V1_V3_cov = 0,
  V1_V3b_cov = 0,
  V2_V2b_cov = 0,
  V2_V3_cov = 0,
  V2_V3b_cov = 0,
  V2b_V3_cov = 0,
  V2b_V3b_cov = 0,
  V3_V3b_cov = 0,
  V1_0 = 0,
  V2_0 = 0,
  V2b_0 = 0,
  V3_0 = 0,
  V3b_0 = 0,
  upLim = 0.5,
  alpha = NULL
)
}
\arguments{
\item{u1, u2, u3}{The U values to be used in the test. Given priority over estimates, but all must be supplied.}

\item{V1Dist}{String value specifying the distribution of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V1}{Value of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V1_VAR}{Value of the variance of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V1_DF}{Degrees of freedom for V1. Only needed if t-distribution is used.}

\item{V2Dist}{String value specifying the distribution of the estimate of the first mediator (and interaction term) on the second mediator.}

\item{V2}{Value of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V2_VAR}{Value of the variance of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V2_DF}{Degrees of freedom for V2.}

\item{V2b}{Value of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V2b_VAR}{Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.}

\item{V2bmult}{Value indicating the value of the independent variable used for the interaction. Typically 1.}

\item{V3Dist}{String value specifying the distribution of the estimate of the second mediator (and interaction term) on the response.}

\item{V3}{Value of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.}

\item{V3_VAR}{Value of the variance of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.}

\item{V3_DF}{Degrees of freedom for V3.}

\item{V3b}{Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.}

\item{V3b_VAR}{Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.}

\item{V1_V2_cov}{Value of the covariance between V1 and V2. Typically 0 for fully observed data.}

\item{V1_V2b_cov}{Value of the covariance between V1 and V2b. Typically 0 for fully observed data.}

\item{V1_V3_cov}{Value of the covariance between V1 and V3. Typically 0 for fully observed data.}

\item{V1_V3b_cov}{Value of the covariance between V1 and V3b. Typically 0 for fully observed data.}

\item{V2_V2b_cov}{Value of the covariance between V2 and V2b}

\item{V2_V3_cov}{Value of the covariance between V2 and V3 Typically 0 for fully observed data.}

\item{V2_V3b_cov}{Value of the covariance between V2 and V3b Typically 0 for fully observed data.}

\item{V2b_V3_cov}{Value of the covariance between V2b and V3. Typically 0 for fully observed data.}

\item{V2b_V3b_cov}{Value of the covariance between V2b and V3b Typically 0 for fully observed data.}

\item{V3_V3b_cov}{Value of the covariance between V3 and V3b.}

\item{V1_0}{Null value for V1.}

\item{V2_0}{Null value for V2.}

\item{V2b_0}{Null value for V2b.}

\item{V3_0}{Null value for V3.}

\item{V3b_0}{Null value for V3b.}

\item{upLim}{The allowed extension, between 0 and 1, of the band towards the center of the region.}

\item{alpha}{Used to ensure correctly controlled type I error for large values of upLim.}
}
\value{
The smallest alpha value for which the generated rejection region leads to rejection of the hypothesis test. Can be used as a p-value.
}
\description{
This function takes 
estimates and covariances, or 3 U values, for the ps-test 
for an ordered mediation scenario.
If estimates are passed to the function, the user must specify 
what distribution is to be used to find the cumulative probabilities.
The p-value of the ps-test is returned. Additionally,
the cutoff, specified by the 
percentage towards the center of the transformation region, 
can be specified.
}
\examples{
ps_ord( u1 = .02, u2= .015, u3 = .995, upLim = .55)
}
