% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idmact_helpers.R
\name{map_scores}
\alias{map_scores}
\title{Map Scores}
\usage{
map_scores(
  df = NULL,
  df_map = NULL,
  conv,
  map_raw,
  map_scale,
  na.rm.max = TRUE
)
}
\arguments{
\item{df}{An optional data frame containing a column for raw scores. If 'df'
is provided and 'conv' is a character, 'conv' should represent the name of the
column in 'df' containing the raw scores.}

\item{df_map}{An optional data frame that maps raw scores to their corresponding
scale scores. If 'df_map' is provided, map_raw' and 'map_scale' should represent
the names of the columns in 'df_map' that describe how raw scores map to scale
scores.}

\item{conv}{Either a list of raw scores to be converted or a string representing
the name of a column in 'df' containing the raw scores.}

\item{map_raw}{Either a list containing the domain of raw scores for the
raw-to-scale score mapping, or a string representing the name of a column in
either 'df' or 'df_map' containing these values.}

\item{map_scale}{Either a list containing the range of scale scores for the
raw-to-scale score mapping, or a string representing the name of a column in
either 'df' or 'df_map' containing these values.}

\item{na.rm.max}{Logical. Should missing values be removed when computing the
maximum raw and scale values in the mapping? Default is TRUE.}
}
\value{
A list of scale scores.
}
\description{
This function converts raw scores into scale scores using a provided mapping.
The mapping can be provided directly as lists through 'map_raw' and 'map_scale',
or indirectly via columns within either 'df' or 'df_map' data frames.
}
\examples{
# Convert raw scores to scale scores using lists
map_scores(conv = list(1, 2, 3, 4, 5),
           map_raw = list(1, 2, 3, 4, 5),
           map_scale = list(20, 21, 22, 23, 24))

# Convert raw scores to scale scores using a data frame
df <- data.frame(Id = 1:5, RawScore = 1:5)
df_map <- data.frame(Raw = 1:5, Scale = 20:24)
df$ScaleScore <- map_scores(df, df_map, conv = "RawScore", map_raw = "Raw", map_scale = "Scale")
}
