% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armRatioCI.R
\name{armRatioCI}
\alias{armRatioCI}
\alias{swapChrRegionDfSizeAndMarks}
\title{FUNCTIONS armRatioCI and swapChrRegionDfSizeAndMarks.}
\usage{
armRatioCI(dfChrSize, rnumeric = FALSE)

swapChrRegionDfSizeAndMarks(dfChrSize, dfMarkPos, chrNamesToSwap)
}
\arguments{
\item{dfChrSize}{name of data.frame with columns: shortArmSize, longArmSize}

\item{rnumeric}{boolean, returns only numeric AR, CI}

\item{dfMarkPos}{name of data.frame of marks}

\item{chrNamesToSwap}{name of chr. names to swap arms}
}
\value{
data.frame (armRatioCI)

list of data.frames (swapChrRegionDfSizeAndMarks)
}
\description{
armRatioCI: reads a data.frame and produces AR (arm ratio), CI
(centromeric index) , Guerra and Levan classifications.

swapChrRegionDfSizeAndMarks: reads data.frames to swap arms
}
\examples{
armRatioCI(dfOfChrSize)
armRatioCI(bigdfOfChrSize)

swapChrRegionDfSizeAndMarks(dfOfChrSize, dfOfMarks, "1")
}
\references{
LEVAN A, FREDGA K, SANDBERG AA (1964) NOMENCLATURE FOR
CENTROMERIC POSITION ON CHROMOSOMES. Hereditas 52:201-220.

Guerra. 1986. Reviewing the chromosome nomenclature of Levan et
al. Braz. Jour. Gen. Vol IX, 4, 741-743
}
\seealso{
\code{\link{chrbasicdatamono}}
}
\keyword{arm}
\keyword{data.frame}
\keyword{size}
