% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency_criterions.R
\name{EvaluateDesign}
\alias{EvaluateDesign}
\title{Calculate efficiency measures for a given design}
\usage{
EvaluateDesign(des, par.draws, n.alts, alt.cte = NULL, no.choice = FALSE)
}
\arguments{
\item{des}{A design matrix in which each row is an alternative.}

\item{par.draws}{A matrix or a list, depending on \code{alt.cte}.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{alt.cte}{A binary vector indicating for each alternative whether an
alternative specific constant is present in the design. The default is \code{NULL}.}

\item{no.choice}{A logical value indicating whether the design has a no choice
alternative. The default is \code{FALSE}.}
}
\value{
\item{AB.error}{Numeric value indicating the A(B)-error of the design.}
\item{DB.error}{Numeric value indicating the D(B)-error of the design.}
\item{SD}{The standard deviations of the parameters. Calculated by taking the diagonal of the varcov matrix, averaged over all draws if a sample matrix was provided in \code{par.draws}.}
\item{level.count}{The count of all levels of each attribute in the design.}
\item{level.overlap}{The count of overlapping levels accross alternatives in every choice set in the design.}
\item{Orthogonality}{Numeric value indicating the degree of orthogonality of the design. The closer the value to 1, the more orthogonal the design is.}
}
\description{
This function calculates the following measures for a given design: AB-error, DB-error, standard deviations of the parameters, level frequency, level overlaps, and orthogonality.
}
\details{
The rules for specifying the function arguments are the same as in \code{\link{Modfed}} or \code{\link{CEA}}.

Alternative specific constants can be specified in \code{alt.cte}, if the design has any.
The length of this binary vector should equal \code{n.alts}, were \code{0} indicates the
absence of an alternative specific constant and \code{1} the opposite.

\code{par.draws} should be a matrix in which each row is a draw from a multivariate
distribution. However, if there are alternative specific constants in the specified design,
then \code{par.draws} should be a list containing two matrices: The first matrix containing
the parameter draws for the alternative specific constant parameters. The second matrix
containing the draws for the rest of the parameters.

If the design has a no.choice alternative, then \code{no.choice} should be set to \code{TRUE}.
}
\examples{
des <- example_design
mu = c(-1, -1.5, -1, -1.5, 0.5, 1)
Sigma = diag(length(mu))
par.draws <- MASS::mvrnorm(100, mu = mu, Sigma = Sigma)
n.alts = 2
EvaluateDesign(des = des, par.draws = par.draws, n.alts = n.alts)

#Example with a no.choice alternative
des.nc <- nochoice_design
mu = c(0.2, -0.5, -1, -0.5, -1, 0.5, 1)
Sigma = diag(length(mu))
par.draws <- MASS::mvrnorm(100, mu = mu, Sigma = Sigma)
par.draws <- list(par.draws[,1], par.draws[,-1])
n.alts = 3
EvaluateDesign(des = des.nc, par.draws = par.draws, n.alts = n.alts,
   alt.cte = c(0,0,1), no.choice = TRUE)
}
