% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_LCMLE.R
\name{ic_LCMLE}
\alias{ic_LCMLE}
\title{Compute the log-concave MLE for Interval-censored Data using an Active Set Algorithm}
\usage{
ic_LCMLE(
  X,
  initial = "LCM",
  print = FALSE,
  max_iter = 500,
  tol_conv = 1e-07,
  tol_conv_like = 1e-10,
  tol_K = 1e-05
)
}
\arguments{
\item{X}{A matrix with two columns, where each row represents an interval (L, R] for interval-censored data.
\code{L} and \code{R} are the left and right endpoints, with \code{R = Inf} indicating right-censoring.}

\item{initial}{A character string specifying the method of obtaining an initial value ("LCM" or "MLE") for the estimation process. Default is \code{"LCM"}.}

\item{print}{Logical. If \code{TRUE}, prints the iterative process details. Default is \code{FALSE}.}

\item{max_iter}{An integer specifying the maximum number of iterations for the algorithm. Default is 500.}

\item{tol_conv}{A numeric tolerance level for convergence based on the directional derivatives. Default is \code{1e-7}.}

\item{tol_conv_like}{A numeric tolerance level for convergence based on log-likelihood difference. Default is \code{1e-10}.}

\item{tol_K}{A numeric tolerance for checking if v^T phi is in K (constraint set) in active constraint set \code{A}. Default is \code{1e-5}.}
}
\value{
A list with the following components:
\item{est}{A list containing \code{tau_no_Inf} (unique finite \code{tau} values), \code{phi_hat} (estimate of \code{log F}), and \code{F_hat} (estimate of \code{F}).}
\item{knot_info}{A list with \code{knot_index} (indices of active knots in \code{tau_no_Inf}), \code{tau_on_knot} (tau values at active knots), 
                \code{F_on_knot} (MLE cumulative distribution function values at active knots), and \code{phi_on_knot} (logarithmic estimates of \code{F} at active knots).}
\item{neg_log_likelihood}{Vector of negative log-likelihood values for each iteration of the algorithm.}
\item{dir_derivs}{Vector of directional derivatives for each iteration.}
\item{iter_no}{Integer representing the total number of iterations.}
\item{weight}{Vector of weights corresponding to each interval in the data.}
\item{X}{The original interval-censored data matrix input.}
}
\description{
This function computes the log-concave MLE of the cumulative distribution function for interval-censored data under log-concavity
on the underlying distribution function based on an active set algorithm. The active set algorithm adjusts the knots set based on
certain directional derivatives.
}
\examples{
# Example usage:
data(lgnm)
result <- ic_LCMLE(X = lgnm, initial = "LCM", print = TRUE, max_iter = 500)
print(result$est)
}
