% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_decimal.R
\name{add_decimal}
\alias{add_decimal}
\title{Insert decimals to the ICD codes}
\usage{
add_decimal(df, icd_cols, places = 3)
}
\arguments{
\item{df}{The dataframe to be converted.}

\item{icd_cols}{A character vector specifying the names of the columns containing ICD codes.}

\item{places}{An numeric value specifying the number of decimal places. Default is 3 decimal places.}
}
\value{
A dataframe in wide format where each row represents a unique identifier (ID),
and each column contains a variable associated with that ID.
}
\description{
This is a preprocessing step to standardize the icd codes to have decimals.
}
\examples{
df <- data.frame(
  id = c(1, 2, 3),
  icd_1 = c("C509", "D633", "I210"),
  icd_2 = c("D509", "E788", "N183")
)
add_decimal(df, icd_cols = c("icd_1", "icd_2"), places = 3)
}
