% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toyModel.R
\name{toyModel}
\alias{toyModel}
\title{Toy model data for using ICA, MICA, and GroupICA
There are 7 types of simulation:
ICA_Type1: Time-independent sub-gaussian data
ICA_Type2: Time-independent super-gaussian data
ICA_Type3: Data mixed with signals having no time dependence and different kurtosis
ICA_Type4: Time-dependent data
ICA_Type5: Toydata to model IPCA in N < P systems
MICA: Two time-serices data to model MICA
GroupICA: Toydata to model GroupICA}
\usage{
toyModel(model = "ICA_Type1", seeds = 123)
}
\arguments{
\item{model}{"ICA_Type1", "ICA_Type2", "ICA_Type3", "ICA_Type4",
and "ICA_Type5", "MICA", and "GrouICA" are available
(Default: "ICA_Type1").}

\item{seeds}{Random number for setting set.seeds in the function (Default: 123).}
}
\value{
A list containing simulation data sets.
}
\description{
Toy model data for using ICA, MICA, and GroupICA
There are 7 types of simulation:
ICA_Type1: Time-independent sub-gaussian data
ICA_Type2: Time-independent super-gaussian data
ICA_Type3: Data mixed with signals having no time dependence and different kurtosis
ICA_Type4: Time-dependent data
ICA_Type5: Toydata to model IPCA in N < P systems
MICA: Two time-serices data to model MICA
GroupICA: Toydata to model GroupICA
}
\examples{
data1 <- toyModel("ICA_Type1")
data2 <- toyModel("ICA_Type2")
data3 <- toyModel("ICA_Type3")
data4 <- toyModel("ICA_Type4")
data5 <- toyModel("ICA_Type5")
data6 <- toyModel("MICA")
data7 <- toyModel("GroupICA")
}
