% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mroPara.R
\name{mroPara}
\alias{mroPara}
\title{Calculate MRO inference}
\usage{
mroPara(obj, conf.levels = 1.96, nonparallel = NULL)
}
\arguments{
\item{obj}{an MRO object created by \code{iNZightMR}}

\item{conf.levels}{confidence level to use, default is 1.96 for 95\% intervals}

\item{nonparallel}{Should these things be parallel?}
}
\value{
An object of class \code{mrocalc}
}
\description{
Calculates required proportions, their differences, variance-covariance
matrices, standard errors of differences, and comparison intervals for differences,
over all of the data. To compute values over various subsets of another
explanatory variable, see \link{by}.
}
\examples{
mr <- iNZightMR(online ~ onlinegame + onlinevideo + onlinemusic,
    data = census.at.school.5000)
mrp <- mroPara(mr)
}
\seealso{
\link{iNZightMR}
}
