% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.NormalIG.Hierarchical.R
\name{sim.NormalIG.Hierarchical}
\alias{sim.NormalIG.Hierarchical}
\title{Simulate an MRMC data set comparing two modalities by a hierarchical model}
\usage{
sim.NormalIG.Hierarchical(
  config,
  R = NULL,
  AR = NULL,
  BR = NULL,
  is.within = FALSE
)
}
\arguments{
\item{config}{[list] of simulation parameters:
\itemize{
  \item Experiment labels and size
  \itemize{
    \item \code{modalityID}: [vector] label modality A and B.
    \item \code{nR}: [num] number of readers
    \item \code{nC}: [num] number of cases
    \item \code{C_dist}: [chr] distribution of the case. Default \code{C_dist="normal"}
  }
  \item Mean and fixed effects:
  \itemize{
    \item \code{mu}: [num] grand mean
    \item \code{tau_A}: [num] modality A
    \item \code{tau_B}: [num] modality B
  }
  \item Reader-case interaction term
  \itemize{
    \item \code{sigma_C}: [num] std of case factor (if \code{C_dist="normal"})
    \item \code{a_C}:     [num] alpha for distribution of case (if \code{C_dist="beta"})
    \item \code{b_C}:     [num] beta for distribution of case (if \code{C_dist="beta"})
    \item \code{alpha_R}: [num] shape parameter for reader
    \item \code{beta_R}:  [num] scale parameter for reader
  }
  \item Modality-reader-case-replicate interaction term for modality A
    \itemize{
    \item \code{sigma_C.A}: [num] std of case factor (if \code{C_dist="normal"})
    \item \code{a_C.A}:     [num] alpha for distribution of case (if \code{C_dist="beta"})
    \item \code{b_C.A}:     [num] beta for distribution of case (if \code{C_dist="beta"})
    \item \code{alpha_R.A}: [num] shape parameter for reader
    \item \code{beta_R.A}:  [num] scale parameter for reader
  }
  \item Modality-reader-case-replicate interaction term for modality B
    \itemize{
    \item \code{sigma_C.B}: [num] std of case factor (if \code{C_dist="normal"})
    \item \code{a_C.B}:     [num] alpha for distribution of case (if \code{C_dist="beta"})
    \item \code{b_C.B}:     [num] beta for distribution of case (if \code{C_dist="beta"})
    \item \code{alpha_R.B}: [num] shape parameter for reader
    \item \code{beta_R.B}:  [num] scale parameter for reader
  }
  \item Scales for the case related terms and interaction terms
    \itemize{
      \item \code{C_scale}:      [num] weight for the case factor
      \item \code{RC_scale}:     [num] weight for the reader-case interaction term
      \item \code{tauC_scale}:   [num] weight for the modality-case term
      \item \code{tauRCE_scale}: [num] weight for the modality-reader-case-replicate interaction term
  }
}}

\item{R}{[vector] of size \code{nR} of reader factors pre-generated from
a gamma(\code{alpha_R}, \code{beta_R}) distribution 
to allow the reader factor to be fixed across multiple simulations.
Default \code{= NULL}}

\item{AR}{[vector] of size \code{nR} of modality-reader interaction terms
pre-generated from a gamma(\code{alpha_R.A}, \code{beta_R.A}) distribution 
to allow the modality-reader interaction terms to be
fixed across multiple simulations the modality-reader interaction.
Default \code{= NULL}}

\item{BR}{[vector] of size \code{nR} of modality-reader interaction terms
pre-generated from a gamma(\code{alpha_R.B}, \code{beta_R.B}) distribution 
to allow the modality-reader interaction terms to be
fixed across multiple simulations the modality-reader interaction.
Default \code{= NULL}}

\item{is.within}{[bol] whether the data are within-modality (A==B).
In this case the modality-reader and modality-case interaction terms 
will be the same.
Default \code{= FALSE}}
}
\value{
df   [data.frame] with nR x nC x 2 rows including
\itemize{
  \item readerID: [Factor] w/ nR levels "reader1", "reader2", ...
  \item caseID: [Factor] w/ nC levels "case1", "case2", ...
  \item modalityID: [Factor] w/ 2 levels "testA" and "testB"
  \item score: [num] reader score
}
}
\description{
This procedure simulates an MRMC data set for an MRMC agreement study comparing two 
modalities. It is a hierarchical model that consists of two interaction terms: reader-case
interaction and modality-reader-case-replicate interaction. Both interaction
terms are conditionally normally distributed, with the case(-related) factor contributing 
to the conditional mean and the reader(-related) factor contributing to the conditional 
variance. The case effect is normally distributed, while the reader effect is
an inverse-gamma.

The Hierarchical Inverse-Gamma model is described in this paper:

\itemize{
  \item S. Wen and B. D. Gallas,
    “Three-Way Mixed Effect ANOVA to Estimate MRMC Limits of Agreement,”
    \emph{Statistics in Biopharmaceutical Research}, \strong{14}, pp. 532–541, 2022,
    \doi{10.1080/19466315.2022.2063169}
}
}
\details{
The model has the following structure:
X.ijkl = mu + m.i + RC.jk + mRCE.ijkl
\itemize{
  \item mu = grand mean
  \item m.i = modalities (levels: A and B)
  \item RC.jk given R.j,C.k ~ N(C.k, R.j) reader-case interaction term
  \item mRCE.ijkl given mR.ij,mC.ik ~ N(mC.ik, mR.ij) modality-reader-case-replicate term
  \item C.k and mC.ik are Normal/beta distributed
  \item R.j and mR.ij are Inverse-Gamma distributed
}
}
