% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{units}
\alias{units}
\title{A table with localized data on units}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1722 rows and 1281 columns.
}
\usage{
units
}
\description{
The \code{units} table contains localized character data across
574 locales. There are 1722 rows and
1281 columns. Each row represents a display type (\code{"long"},
\code{"short"}, or \code{"narrow"}) for each of the locales.

Following the \code{locale} and \code{type} columns, each unit and its subelements
are provided as a cluster of columns in the form
\code{"<<category>-unit name>.<subelement name>"}. The subelement names are:
\itemize{
\item \code{"displayName"}
\item \code{"unitPattern-count-one"}
\item \code{"unitPattern-count-other"}
\item \code{"unitPattern-count-zero"}
\item \code{"unitPattern-count-two"}
\item \code{"unitPattern-count-few"}
\item \code{"unitPattern-count-many"}
}

The \code{"displayName"} is the localized name for a unit when displayed outside
of a pattern. The \code{"unitPattern-count-*"} subelements provide the localized
forms of the unit when the value is exactly \code{0} (\code{"unitPattern-count-one"}),
\code{1} (\code{"unitPattern-count-one"}), \code{2} (\code{"unitPattern-count-two"}), and, when
the value constitutes a few (\code{"unitPattern-count-few"}) or many
(\code{"unitPattern-count-many"}) units. Every other case is handled by
\code{"unitPattern-count-other"}.
}
\keyword{datasets}
