% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{upper}
\alias{upper}
\alias{upper.confidence_set}
\title{Extract the upper bound of a confidence set}
\usage{
upper(x, ...)

\method{upper}{confidence_set}(x, ...)
}
\arguments{
\item{x}{a confidence_set object}

\item{...}{additional arguments (ignored)}
}
\value{
Named numeric scalar with the upper bound.
}
\description{
Extract the upper bound of a confidence set
}
\examples{
cs <- invert_test(
  function(theta) wald_test(estimate = 5, se = 1.2, null_value = theta),
  grid = seq(0, 10, by = 0.1)
)
upper(cs)
}
