% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{intersection_test}
\alias{intersection_test}
\title{Intersection Test (AND)}
\usage{
intersection_test(...)
}
\arguments{
\item{...}{\code{hypothesis_test} objects or numeric p-values.}
}
\value{
A \code{hypothesis_test} of subclass \code{intersection_test} with fields
\code{n_tests} and \code{component_pvals}.
}
\description{
Combines hypothesis tests using the AND rule: rejects only when ALL
component tests reject.
}
\details{
The p-value is \eqn{\max(p_1, \ldots, p_k)} — the intersection rejects
at level \eqn{\alpha} if and only if every component p-value is below
\eqn{\alpha}.

This is the intersection-union test (IUT; Berger, 1982). No multiplicity
correction is needed — the max is inherently conservative.
}
\section{Use Case --- Bioequivalence}{

Bioequivalence requires showing a drug's effect is both "not too low"
AND "not too high". This is naturally an intersection test.
}

\section{Boolean Algebra}{

Together with \code{\link[=complement_test]{complement_test()}} (NOT) and \code{\link[=union_test]{union_test()}} (OR), this
forms a complete Boolean algebra. De Morgan's law holds by construction:
\code{union_test(a, b) = complement_test(intersection_test(complement_test(a), complement_test(b)))}
}

\examples{
# All must reject for intersection to reject
intersection_test(0.01, 0.03, 0.04)  # significant
intersection_test(0.01, 0.80)         # not significant

}
\seealso{
\code{\link[=union_test]{union_test()}}, \code{\link[=complement_test]{complement_test()}}, \code{\link[=fisher_combine]{fisher_combine()}}
}
