% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bridges.R
\name{get_bridge_flowlines}
\alias{get_bridge_flowlines}
\alias{get_bridge_flowlines.data.frame}
\alias{get_bridge_flowlines.hy}
\title{Get Bridge Flowlines}
\usage{
get_bridge_flowlines(x, quiet = FALSE)

\method{get_bridge_flowlines}{data.frame}(x, quiet = FALSE)

\method{get_bridge_flowlines}{hy}(x, quiet = FALSE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{quiet}{logical quiet messages?}
}
\value{
vector of flowline ids that are bridge flowlines in the network
}
\description{
Identifies bridge flowlines (cut edges) in the network.
Bridge flowlines are those whose removal would disconnect the network.
Flowlines are edges in the underlying node graph, so bridge detection
correctly identifies the sole-path flowlines that separate parts of the
network -- including flowlines within diversion systems that do not rejoin.
}
\details{
Required attributes: \code{id}, \code{toid}
}
\examples{

x <- data.frame(
  id = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
  toid = c(2, 3, 4, 5, 0, 7, 8, 9, 4)
)

# 1 -> 2 -> 3 -> 4 -> 5
#               ^
#               |
# 6 -> 7 -> 8 -> 9
#
# Dendritic tree: all flowlines are bridges
get_bridge_flowlines(x)

}
