% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{st_compatibalize}
\alias{st_compatibalize}
\title{Make Spatial Inputs Compatible}
\usage{
st_compatibalize(sf1, sf2)
}
\arguments{
\item{sf1}{sf data.frame}

\item{sf2}{sf data.frame}
}
\value{
sf1 transformed and renamed to be compatible with sf2
}
\description{
makes sf1 compatible with sf2 by projecting into
the projection of 2 and ensuring that the geometry columns are the
same name.
}
\examples{

x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

one <- dplyr::select(x)
two <- sf::st_transform(one, 5070)

attr(one, "sf_column") <- "geotest"
names(one)[names(one) == "geom"] <- "geotest"

st_compatibalize(one, two)

}
