\name{SpecificValueInFile}

\alias{SpecificValueInFile}

\title{
Straightforward modification of a value in input text file
}
\description{
This function provides the capability to modify input text files directly within the R environment, requering only minimal instructions. It was conceived to facilitate users to execute the calibration procedure via \code{hydroMOPSO()}, while staying entirely within  the R environment. Thus, it precludes the need for manually editing text files, eliminating undesirable coordination that could potentially lead to errors.
}
\usage{
SpecificValueInFile(modlist)
}

\arguments{
  \item{modlist}{(\code{list}) \cr
A list with as many objects as modifications to be made in the text files. In turn, each object is a list with the specifications of the modification to be made. See \sQuote{Details} for the contents of each list.
}
}

\details{

The \code{modlist} argument is a list with an indeterminate number of objects, which only depends on the number of modifications the user needs to make, for example, being something like \code{modlist=list(mod_1, mod_2, mod_3,mod_4)}. Each of the \sQuote{\code{mod}} objects in this list \bold{must} provide the following items:
  \describe{    
    \item{ParamID}{(\code{character}) \cr
      The ID of the parameter to be modified.
    }
    \item{newvalue}{(\code{numeric}) \cr
      Numeric value to be written into the text file.
    }
    \item{filename}{(\code{character}) \cr
      Name of the text file that will be modified.
    }
    \item{row}{(\code{numeric}) \cr
      Row number in \code{filename} where \code{newvalue} will be written.
    }
    \item{col.ini}{(\code{numeric}) \cr
       Starting column number in \code{filename} where \code{newvalue} is going to be written.
    }
    \item{col.fin}{(\code{numeric}) \cr
      Ending column number in \code{filename} where \code{newvalue} is going to be written.
    }
    \item{decimals}{(\code{numeric}) \cr
      Number of decimal places used to write \code{newvalue} into \code{filename}.
    }
  }
}


\value{
No return value
}

\author{
Rodrigo Marinao Rivas \email{ra.marinao.rivas@gmail.com}, Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}

\seealso{
\code{\link{hydromod}}
}

\keyword{files}
