% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scour.R
\name{scour_curve}
\alias{scour_curve}
\title{Scour depth in a curve}
\usage{
scour_curve(A,v,Fr,h,J,r,rm,d84,d16,dm=NULL,psi=NULL,method="Peter")
}
\arguments{
\item{A}{wetted area upstream the curve [m2]}

\item{v}{flow velocity upstream the curve [m/s]}

\item{Fr}{Froude number upstream the curve [-]}

\item{h}{flow depth in the middle of the river upstream the curve [m]}

\item{J}{bottom slope [-]}

\item{r}{curve radius from center to the outer bank bottom [m]}

\item{rm}{curve radius from center to the middle of the river [m]}

\item{d84}{d84 of grain size distribution [mm]}

\item{d16}{d16 of grain size distribution [mm]}

\item{dm}{d50 of grain size distribution [mm]}

\item{psi}{inner friction angle[°]. Values between 20° and 25° are
recommended for flat rivers (J~0.0003). For steeper rivers (0.0035 < J <
0.007), values between 35° and 40° are recomended (Bezzola 2012).}

\item{method}{method to calculate scour depth. valid values are "Peter",
"Bridge" or "Kikkawa"}
}
\value{
\item{T0}{water table at maximal scour depth [m]}
\item{S}{difference between bed elevation at the middle of the river upstream
  the curve and the maximal scour depth  [m]}
\item{val}{if val = T, the criterion for method "Peter" is fullfilled}
}
\description{
Calculate scour depth formed in a curve.
}
\examples{
## calculate scour depth accordint to Peter

# Define parameter
A <- 135.5
Fr <- 0.52
h <- 3.31
J <- 0.0022
r <- 500
rm <- 530
d16 <- 50
d84 <- 200

scour_curve(
  A = A, Fr = Fr, h = h, J = J, rm = rm, r = r,
  d16 = d16, d84 = d84
)

## calculate scour depth accordint to Bridge

# Define parameter
h <- 3.31
r <- 500
rm <- 530
psi <- 20

scour_curve(h = h, rm = rm, r = r, method = "Bridge", psi = psi)

## calculate scour depth according to Kikkawa

# Define parameter
v <- 2.7
h <- 3.31
J <- 0.0022
r <- 500
rm <- 470
dm <- 80

scour_curve(
  v = v, h = h, J = J, rm = rm, r = r,
  dm = dm, method = "Kikkawa"
)

}
\references{
Bezzola (2012). Vorlesungsmanuskript Flussbau. ETH Zürich.
}
