% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_exposure.R
\name{events_exposure}
\alias{events_exposure}
\title{Write storm events exposure files}
\usage{
events_exposure(
  locations,
  start_year,
  end_year,
  event_type,
  out_dir,
  out_type = "csv"
)
}
\arguments{
\item{locations}{Either a vector of FIPS county codes, for county-level
output, or a dataframe with columns for community identifier (\code{commun})
and associated FIPS codes (\code{fips}), for multi-county community output.
See the examples for the proper format for this argument.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{event_type}{Character string with the type of event to use to identify
county exposures. Options include \code{"flood"}, \code{"tornado"},
\code{"wind"}, and \code{"tropical_storm"}.}

\item{out_dir}{Character string with the filepath to the directory where the
data will be saved}

\item{out_type}{Character string with the type of file to save to. Options are
"csv" for a comma-separated file (default) and "rds" for an R object file.}
}
\value{
Writes out a directory with rain exposure files for each county or
   community indicated. For more on the columns in this output, see the
   documentation for \code{\link{county_rain}} and
   \code{\link{multi_county_rain}}.
}
\description{
This function takes an input of locations (either a vector of county FIPS
or a dataframe of multi-county FIPS, with all FIPS listed for each county)
and creates a dataframe with storm listings and dates that can be merged with
time series of health or other outcomes, giving the dates and exposures for all
storms meeting the given storm events criteria.
}
\examples{
\dontrun{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

# To run this example, you will need to have a directory named "tmp"
# as a subdirectory of your home directory.

# By county
events_exposure(locations = c("22071", "51700"),
                start_year = 1995, end_year = 2005,
                event_type = "flood",
                out_dir = "~/tmp/storms")
                }
 }

}
