% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_beta.R
\name{update_beta}
\alias{update_beta}
\title{MCMC Second-Component Parameter Update Function for Hurdle Model Count Data
Regression}
\usage{
update_beta(y, x, hurd, dist, like.part, beta.prior.mean, beta.prior.sd, beta,
  XB, beta.acc, beta.tune, g.x = F)
}
\arguments{
\item{y}{numeric response vector of observations within the bounds of the 
second component of the likelihood function, \eqn{y[0 < y \& y < hurd]}}

\item{x}{optional numeric predictor matrix for response observations within 
the bounds of the second component of the likelihood function, 
\eqn{y[0 < y \& y < hurd]}.}

\item{hurd}{numeric threshold for 'extreme' observations of two-hurdle models.}

\item{dist}{character specification of response distribution for the third 
component of the likelihood function.}

\item{like.part}{numeric vector of the current third-component likelihood values.}

\item{beta.prior.mean}{mu parameter for normal prior distributions.}

\item{beta.prior.sd}{standard deviation for normal prior distributions.}

\item{beta}{numeric matrix of current regression coefficient parameter values.}

\item{XB}{\eqn{x*beta[,1]} product matrix for response observations within the bounds 
of the second component of the likelihood function, \eqn{y[0 < y \& y < hurd]}.}

\item{beta.acc}{numeric matrix of current MCMC acceptance rates for 
regression coefficient parameters.}

\item{beta.tune}{numeric matrix of current MCMC tuning values for regression 
coefficient estimation.}

\item{g.x}{logical operator. \code{TRUE} if operating within the third component 
of the likelihood function (the likelihood of 'extreme' observations).}
}
\value{
A list of MCMC-updated regression coefficients for the estimation of 
the second-component likelihood parameter as well as each coefficient's MCMC
acceptance ratio.
}
\description{
MCMC algorithm for updating the second-component likelihood 
parameters in hurdle model regression using \code{\link{hurdle}}.
}
\seealso{
\code{\link{hurdle}} \cr
\code{\link{dist_ll}}
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
