% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsphase.R
\name{.hblock}
\alias{.hblock}
\title{Build haplotype blocks from a BMH result matrix (native routine wrapper)}
\usage{
.hblock(bmhResult, MaxBlock = 400)
}
\arguments{
\item{bmhResult}{A numeric/integer matrix containing BMH results (block
matching/haplotype-block intermediate output). Must be a matrix.}

\item{MaxBlock}{Integer scalar. Maximum block size (default: 400).}
}
\value{
A matrix (same general shape as \code{bmhResult}) containing inferred
  block structure. Row and column names are propagated from \code{bmhResult}
  where available.
}
\description{
Internal wrapper around the native C routine \code{hblock}. It transforms a
BMH result matrix into a block representation, with an optional maximum block
size constraint.
}
\details{
This function transposes and flattens \code{bmhResult} before passing it to
compiled code via \code{\link[base]{.C}}:
\code{.C("hblock", ...)}.
}
