% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/howler.R
\name{howler-shiny}
\alias{howler-shiny}
\alias{howlerOutput}
\alias{renderHowler}
\title{Shiny bindings for howler}
\usage{
howlerOutput(outputId)

renderHowler(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{expr}{An expression that generates a howler}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the widget within Shiny applications.
}
\description{
Output and render functions for using howler within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "howler.js Player",
    howlerOutput("howler"),
    howlerPlayPauseButton("howler")
  )

  server <- function(input, output) {
    output$howler <- renderHowler(howler(c(sound = "audio/sound.mp3")))
  }

  shinyApp(ui, server)
}

}
