% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team.R
\name{nba_teaminfocommon}
\alias{nba_teaminfocommon}
\title{\strong{Get NBA Stats API Team Common Info}}
\usage{
nba_teaminfocommon(
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  team_id = "1610612749",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{team_id}{Team ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: AvailableSeasons, TeamInfoCommon,
TeamSeasonRanks

\strong{TeamInfoCommon}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   SEASON_YEAR \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CONFERENCE \tab character \cr
   TEAM_DIVISION \tab character \cr
   TEAM_CODE \tab character \cr
   TEAM_SLUG \tab character \cr
   W \tab character \cr
   L \tab character \cr
   PCT \tab character \cr
   CONF_RANK \tab character \cr
   DIV_RANK \tab character \cr
   MIN_YEAR \tab character \cr
   MAX_YEAR \tab character \cr
}


\strong{TeamSeasonRanks}\tabular{ll}{
   col_name \tab types \cr
   LEAGUE_ID \tab character \cr
   SEASON_ID \tab character \cr
   TEAM_ID \tab character \cr
   PTS_RANK \tab character \cr
   PTS_PG \tab character \cr
   REB_RANK \tab character \cr
   REB_PG \tab character \cr
   AST_RANK \tab character \cr
   AST_PG \tab character \cr
   OPP_PTS_RANK \tab character \cr
   OPP_PTS_PG \tab character \cr
}


\strong{AvailableSeasons}\tabular{ll}{
   col_name \tab types \cr
   SEASON_ID \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Common Info}

\strong{Get NBA Stats API Team Common Info}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teaminfocommon(team_id = '1610612749')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()},
\code{\link{nba_teamdetails}()},
\code{\link{nba_teamestimatedmetrics}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamelog}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{NBA Team Functions}
