% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playerawards}
\alias{nba_playerawards}
\title{\strong{Get NBA Stats API Player Awards}}
\usage{
nba_playerawards(player_id, ...)
}
\arguments{
\item{player_id}{Player ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerAwards

\strong{PlayerAwards}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   TEAM \tab character \cr
   DESCRIPTION \tab character \cr
   ALL_NBA_TEAM_NUMBER \tab character \cr
   SEASON \tab character \cr
   MONTH \tab character \cr
   WEEK \tab character \cr
   CONFERENCE \tab character \cr
   TYPE \tab character \cr
   SUBTYPE1 \tab character \cr
   SUBTYPE2 \tab character \cr
   SUBTYPE3 \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player Awards}

\strong{Get NBA Stats API Player Awards}
}
\details{
\href{https://www.nba.com/stats/player/2544/career}{Player Awards}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playerawards(player_id = '2544')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercareerstats}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerestimatedmetrics}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelogs}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playernextngames}()},
\code{\link{nba_playerprofilev2}()},
\code{\link{nba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Functions}
