% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_leaders.R
\name{nba_homepageleaders}
\alias{nba_homepageleaders}
\title{\strong{Get NBA Stats API Homepage Leaders}}
\usage{
nba_homepageleaders(
  league_id = "00",
  game_scope = "Season",
  player_or_team = "Team",
  player_scope = "All Players",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  stat_category = "Points",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{game_scope}{Game Scope - Season, Last 10, ,Yesterday, Finals}

\item{player_or_team}{Player or Team}

\item{player_scope}{Player Scope - All Players, Rookies}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs}

\item{stat_category}{Stat Category: Points, Rebounds, Assists, Defense, Clutch, Playmaking, Efficiency, Fast Break, Scoring Breakdown}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: HomePageLeaders, LeagueAverage, LeagueMax

\strong{HomePageLeaders}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   PTS \tab character \cr
   FG_PCT \tab character \cr
   FG3_PCT \tab character \cr
   FT_PCT \tab character \cr
   EFG_PCT \tab character \cr
   TS_PCT \tab character \cr
   PTS_PER48 \tab character \cr
}


\strong{LeagueAverage}\tabular{ll}{
   col_name \tab types \cr
   PTS \tab numeric \cr
   FG_PCT \tab numeric \cr
   FG3_PCT \tab numeric \cr
   FT_PCT \tab numeric \cr
   EFG_PCT \tab numeric \cr
   TS_PCT \tab numeric \cr
   PTS_PER48 \tab numeric \cr
}


\strong{LeagueMax}\tabular{ll}{
   col_name \tab types \cr
   PTS \tab numeric \cr
   FG_PCT \tab numeric \cr
   FG3_PCT \tab numeric \cr
   FT_PCT \tab numeric \cr
   EFG_PCT \tab numeric \cr
   TS_PCT \tab numeric \cr
   PTS_PER48 \tab numeric \cr
}
}
\description{
\strong{Get NBA Stats API Homepage Leaders}

\strong{Get NBA Stats API Homepage Leaders}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_homepageleaders(league_id = '00', player_or_team = "Player")
 nba_homepageleaders(league_id = '00', player_or_team = "Team")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Leaders Functions: 
\code{\link{nba_alltimeleadersgrids}()},
\code{\link{nba_assistleaders}()},
\code{\link{nba_assisttracker}()},
\code{\link{nba_defensehub}()},
\code{\link{nba_homepagev2}()},
\code{\link{nba_leaderstiles}()},
\code{\link{nba_leagueleaders}()}
}
\author{
Saiem Gilani
}
\concept{NBA Leaders Functions}
