% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_nba_wp.R
\name{espn_nba_wp}
\alias{espn_nba_wp}
\title{\strong{Get NBA win probability chart data from ESPN}}
\usage{
espn_nba_wp(game_id)
}
\arguments{
\item{game_id}{(\emph{Integer} required): Game ID filter for querying a single game}
}
\value{
\code{\link[=espn_nba_wp]{espn_nba_wp()}} - A data frame with 21 variables:\tabular{ll}{
   col_name \tab types \cr
   game_id \tab numeric \cr
   play_id \tab character \cr
   home_win_percentage \tab numeric \cr
   away_win_percentage \tab numeric \cr
   tie_percentage \tab numeric \cr
   sequence_number \tab character \cr
   text \tab character \cr
   away_score \tab integer \cr
   home_score \tab integer \cr
   scoring_play \tab logical \cr
   score_value \tab integer \cr
   participants \tab list \cr
   shooting_play \tab logical \cr
   type_id \tab character \cr
   type_text \tab character \cr
   period_number \tab integer \cr
   period_display_value \tab character \cr
   clock_display_value \tab character \cr
   team_id \tab character \cr
   coordinate_x \tab integer \cr
   coordinate_y \tab integer \cr
}
}
\description{
\strong{Get NBA win probability chart data from ESPN}
}
\examples{
\donttest{
  espn_nba_wp(game_id = 401283399)
}

}
\seealso{
Other ESPN NBA Functions: 
\code{\link{espn_nba_betting}()},
\code{\link{espn_nba_game_all}()},
\code{\link{espn_nba_game_rosters}()},
\code{\link{espn_nba_pbp}()},
\code{\link{espn_nba_player_box}()},
\code{\link{espn_nba_player_stats}()},
\code{\link{espn_nba_scoreboard}()},
\code{\link{espn_nba_standings}()},
\code{\link{espn_nba_team_box}()},
\code{\link{espn_nba_team_stats}()},
\code{\link{espn_nba_teams}()}
}
\concept{ESPN NBA Functions}
\keyword{Chart}
\keyword{Data}
\keyword{NBA}
\keyword{Probability}
\keyword{Win}
