% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paillier.R
\docType{class}
\name{PaillierPublicKey}
\alias{PaillierPublicKey}
\title{Construct a Paillier public key with the given modulus.}
\value{
An \code{\link[R6:R6Class]{R6::R6Class()}} generator object
}
\description{
Construct a Paillier public key with the given modulus.

Construct a Paillier public key with the given modulus.
}
\seealso{
\code{\link[=PaillierPrivateKey]{PaillierPrivateKey()}} which goes hand-in-hand with this object
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{bits}}{the number of bits in the modulus}

\item{\code{n}}{the modulus}

\item{\code{nSquared}}{the square of the modulus}

\item{\code{nPlusOne}}{one more than the modulus}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PaillierPublicKey-new}{\code{PaillierPublicKey$new()}}
\item \href{#method-PaillierPublicKey-encrypt}{\code{PaillierPublicKey$encrypt()}}
\item \href{#method-PaillierPublicKey-add}{\code{PaillierPublicKey$add()}}
\item \href{#method-PaillierPublicKey-sub}{\code{PaillierPublicKey$sub()}}
\item \href{#method-PaillierPublicKey-add_real}{\code{PaillierPublicKey$add_real()}}
\item \href{#method-PaillierPublicKey-sub_real}{\code{PaillierPublicKey$sub_real()}}
\item \href{#method-PaillierPublicKey-mult}{\code{PaillierPublicKey$mult()}}
\item \href{#method-PaillierPublicKey-clone}{\code{PaillierPublicKey$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-new"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-new}{}}}
\subsection{Method \code{new()}}{
Create a new public key and precompute some internal values for efficiency
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$new(bits, n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bits}}{number of bits to use}

\item{\code{n}}{the modulus to use}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{PaillierPublicKey} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-encrypt"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-encrypt}{}}}
\subsection{Method \code{encrypt()}}{
Encrypt a message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$encrypt(m)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m}}{the message}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the encrypted message
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-add"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-add}{}}}
\subsection{Method \code{add()}}{
Add two encrypted messages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$add(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{a message}

\item{\code{b}}{another message}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the sum of \code{a} and \code{b}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-sub"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-sub}{}}}
\subsection{Method \code{sub()}}{
Subtract one encrypted message from another
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$sub(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{a message}

\item{\code{b}}{another message}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the difference \code{a - b}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-add_real"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-add_real}{}}}
\subsection{Method \code{add_real()}}{
Return the sum \code{a + b}
of an encrypted real message \code{a},
a list consisting of a encrypted
integer part (named \code{int}) and an
encrypted fractional part (named \code{frac}),
and a real number \code{a} using
\code{den} as denominator in the rational
approximation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$add_real(den, a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{den}}{the denominator to use for rational approximations}

\item{\code{a}}{the \emph{real} message, a list consisting of the integer and fractional parts named \code{int} and \code{frac} respectively}

\item{\code{b}}{a simple real number}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-sub_real"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-sub_real}{}}}
\subsection{Method \code{sub_real()}}{
Return the difference \code{a - b}
of an encrypted real message \code{a},
a list consisting of a encrypted
integer part (named \code{int}) and an
encrypted fractional part (named \code{frac}),
and a real number \code{b} using
\code{den} as denominator in the rational
approximation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$sub_real(den, a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{den}}{the denominator to use for rational approximations}

\item{\code{a}}{the \emph{real} message, a list consisting of the integer and fractional parts named \code{int} and \code{frac} respectively}

\item{\code{b}}{a simple real number}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-mult"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-mult}{}}}
\subsection{Method \code{mult()}}{
Return the product of two encrypted
messages \code{a} and \code{b}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$mult(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{a message}

\item{\code{b}}{another message}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the product of \code{a} and \code{b}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierPublicKey-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierPublicKey-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierPublicKey$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
